PROCEDURE FindPartEnds;
{$DEBUG}

CONST
	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_CONST 2019.px}
	
VAR
	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_VARS.px}
	CutLoc : POINT;
	NumVertices : INTEGER;
	OK : BOOLEAN;
	Part : STRING;
	PartEnd : ARRAY[1..20] OF VECTOR;
	PartHolder : REAL;
	PartLen : ARRAY[1..9] OF REAL;
	PartStart : ARRAY[1..9] OF REAL;
	Path : HANDLE;
	PathLoc : VECTOR;
	PathTan : VECTOR;
	PIOName : STRING;
	PtX, PtY : REAL;
	RunningLen : REAL;
	Slack : STRING;
	SlackHolder : REAL;
	TheCable : HANDLE;
	TheCut : HANDLE;
	TheDist : REAL;
	Vert : STRING;
	VertArray : ARRAY[1..20] OF POINT;
	VertHolder : REAL;
	
{==============================================================}

	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_PROCS SL.px}
	
{==============================================================}

	PROCEDURE CollectVertices(cableObj : HANDLE);
	
	VAR
		index : INTEGER;
		
	BEGIN
		NumVertices := GetVertNum(cableObj);
		(*FOR index := 1 TO NumVertices DO*)
	END; {PROCEDURE CollectVertices}
	
{==============================================================}

	PROCEDURE LocateCut(TheCut, TheCable : HANDLE);
	
	BEGIN
		
	END; {PROCEDURE LocateCut}

{==============================================================}

	PROCEDURE CollectVertices;
					NumVertices:= GetVertNum(pathHd);

					PathDup := CreateDuplicateObject(pathHd,NIL);
					NumVertices:= GetVertNum(PathDup);

					ResVec := Click - OrigVec;
					
					RotVec := RotPtAboutPt(ResVec, PCntr, -1 * CableRotation);
{
					BeginGroup;
						Oval(RotVec.X-5, RotVec.Y+5, RotVec.X+5, RotVec.Y-5);
						Locus(RotVec.X,RotVec.Y);
					EndGroup;
}
	
					NumVertices:= GetVertNum(PathDup);
					FOR Index := 1 TO NumVertices DO
					BEGIN
						GetPolylineVertex(PathDup,Index,Vertex[Index].X,Vertex[Index].Y,VertType[Index],VertRadius[Index]);
						{GetPolylineVertex(pathHd,Index,Vertex[Index].X,Vertex[Index].Y,VertType[Index],VertRadius[Index]);}
						Vertex[Index].X := Vertex[Index].X;
						Vertex[Index].Y := Vertex[Index].Y;
					END;
	END; {PROCEDURE CollectVertices}
	
{==============================================================}

	PROCEDURE CollectPartInfo(theCable : HANDLE)
	
	BEGIN
		PIOName := GetName(GetParametricRecord(theCable));
	END;
	
{==============================================================}

BEGIN
	TheCable := FSActLayer;
	Path := GetCustomObjectPath(TheCable);
	GetSymLoc(TheCable, PathLoc.X, PathLoc.Y);
(*
	CallTool(-201);
	TheCut := FSActLayer;
*)
	RunningLen := 0;
	TheDist := 0;
	PIOName := GetName(GetParametricRecord(TheCable));
	Index := 1;
	PartStart[Index] := 0;
	Part := GetRField(TheCable, PIOName, CONCAT('Part ', Index));
	Vert := GetRField(TheCable, PIOName, CONCAT('PartVert', Index));
	Slack := GetRField(TheCable, PIOName, CONCAT('CblBrk', Index));
	OK := ValidNumStr(Part, PartHolder);
	OK := ValidNumStr(Vert, VertHolder);
	OK := ValidNumStr(Slack, SlackHolder);
	PartLen[Index] := PartHolder - (VertHolder + SlackHolder);
	TheDist := PartLen[Index] + RunningLen;
(*AlrtDialog(concat('TheDist1 = ', Num2StrF(TheDist)));*)
	OK := PointAlongPoly(Path, TheDist, PartEnd[Index], PathTan);
	PartEnd[Index].X := PartEnd[Index].X + PathLoc.X;
	PartEnd[Index].Y := PartEnd[Index].Y + PathLoc.Y;
	RunningLen := RunningLen + TheDist;
(*
BeginGroup;
	Oval(PartEnd[Index].X - 12, PartEnd[Index].Y + 12, PartEnd[Index].X + 12, PartEnd[Index].Y - 12);
	SetFPat(LNewObj,1);
	SetFillBack(LNewObj, 52428, 65535, 52528);
	MoveTo(PartEnd[Index].X, PartEnd[Index].Y);
	CreateText(Num2Str(0, Index));
EndGroup;
REDRAWALL;
*)

	WHILE PartHolder > 0 DO 
		BEGIN
			{DO STURR}
			
			{Get Next Part Info}
			Index := Index + 1;
			Part := GetRField(TheCable, PIOName, CONCAT('Part ', Index));
			OK := ValidNumStr(Part, PartHolder);
			IF PartHolder <> 0 THEN
				BEGIN
					PartStart[Index] := PartStart[Index - 1] + PartLen[Index - 1];
					Vert := GetRField(TheCable, PIOName, CONCAT('PartVert', Index));
					Slack := GetRField(TheCable, PIOName, CONCAT('CblBrk', Index));
					OK := ValidNumStr(Vert, VertHolder);
					OK := ValidNumStr(Slack, SlackHolder);
					PartLen[Index] := PartHolder - (VertHolder + SlackHolder);
					TheDist := PartLen[Index] + RunningLen;
					OK := PointAlongPoly(Path, TheDist, PartEnd[Index], PathTan);
					PartEnd[Index].X := PartEnd[Index].X + PathLoc.X;
					PartEnd[Index].Y := PartEnd[Index].Y + PathLoc.Y;
					RunningLen := TheDist;
(*
BeginGroup;
	Oval(PartEnd[Index].X - 12, PartEnd[Index].Y + 12, PartEnd[Index].X + 12, PartEnd[Index].Y - 12);
	SetFPat(LNewObj,1);
	SetFillBack(LNewObj, 52428, 65535, 52528);
	MoveTo(PartEnd[Index].X, PartEnd[Index].Y);
	CreateText(Num2Str(0, Index));
EndGroup;
REDRAWALL;
*)
				END;
		END; {WHILE PartHolder > 0}
END;
RUN(FindPartEnds);